<!DOCTYPE html>
<html lang="en">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login | ACCESSYSTEM</title>

  <!-- Favicon
  ============================================= -->
  <link rel="shortcut icon" href="templates/accessystem-v8/images/accessystem-icons/favicon.ico" type="image/x-icon" title="ACCESSYSTEM® - IT Solution & Services">
  <link rel="apple-touch-icon" href="templates/accessystem-v8/images/accessystem-icons/accessystem_icon_256x256.png" type="image/png" title="ACCESSYSTEM® - IT Solution & Services">

  <link href="{$BASE_PATH_CSS}/bootstrap.min.css" rel="stylesheet">
  <link href="templates/login.css" rel="stylesheet">
  <link href="templates/accessystem_v5/custom-style.css.php" rel="stylesheet" type="text/css" />
  <script type="text/javascript" src="{$BASE_PATH_JS}/jquery.min.js"></script>
  <script type="text/javascript" src="{$BASE_PATH_JS}/bootstrap.min.js"></script>
  <script type="text/javascript" src="templates/login.min.js"></script>
</head>
<body>
<div class="sm-loading-container">
  <div class="sm-loading">
    <div class="loader"><svg class="circular" viewBox="25 25 50 50">
      <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/>
      </svg></div>
  </div>
</div>
<div class="sm-login-container">
  <div class="sm-split-leftcol">
    <div class="overlay"></div>
  </div>
  <div class="sm-split-rightcol">
    <div class="login-box">
      <div class="logo"><img class="img-responsive" src="templates/login-logo.png" alt="{$companyname}"></div>
      <div class="content">
        <h2>{$displayTitle}</h2>
        {if $infoMsg}
        <div class="infobox"> {$infoMsg} </div>
        {/if}
        {if $successMsg}
        <div class="successbox"> {$successMsg} </div>
        {/if}
        {if $errorMsg}
        <div class="errorbox"> {$errorMsg} </div>
        {/if}
        {if $step eq "login"}
        <form method="post" action="dologin.php">
          <input type="hidden" name="language" id="inputLanguage" />
          <input type="hidden" name="redirect" value="{$redirectUri}" />
          <div class="form-group">
            <input id="login-username" name="username" type="text" autofocus class="form-control" placeholder="Username" />
          </div>
          <div class="form-group">
            <input id="login-password" name="password" type="password" class="form-control" placeholder="Password" />
          </div>
          <div class="row">
            <div class="col-sm-7">
              <div class="checkbox">
                <label>
                  <input type="checkbox" name="rememberme" value="1">
                  Remember me </label>
              </div>
            </div>
            <div class="col-sm-5">
              <input type="submit" value="Login" class="btn btn-primary btn-block">
            </div>
          </div>
        </form>
        {elseif $step eq "reset"}
        <form action="login.php" method="post">
          <input type="hidden" name="action" value="reset" />
          <input type="hidden" name="sub" value="send" />
          <div class="form-group">
            <input type="email" name="email" class="form-control" placeholder="Email address" autofocus />
          </div>
          <div class="form-group">
            <input type="submit" value="Reset Password" class="btn btn-primary btn-block" />
          </div>
        </form>
        {elseif $step eq "twofa"}
        <div class="text-center">{$challengeHtml}</div>
        {elseif $step eq "twofabackupcode"}
        {if $successMsg}
        <p>Write this down on paper and keep it safe.<br />
          It will be needed if you ever lose your 2nd factor device or it is unavailable to you again in future.</p>
        <form method="post" action="dologin.php">
          <input type="hidden" name="redirect" value="{$redirectUri}" />
          <div class="form-group">
            <input type="submit" value="Continue &raquo;" class="btn btn-primary btn-block" />
          </div>
        </form>
        {else}
        <form action="dologin.php" method="post">
          <input type="hidden" name="backupcode" value="1" />
          <input type="hidden" name="redirect" value="{$redirectUri}" />
          <div class="form-group">
            <input type="text" name="code" class="form-control" placeholder="Backup code" autofocus />
          </div>
          <div class="form-group">
            <input type="submit" value="Login" class="btn btn-primary btn-block" />
          </div>
        </form>
        {/if}
        {/if} </div>
      <div class="footer"> {if $step eq "login"}
        {if $showPasswordResetLink} <a href="login.php?action=reset"> Forgot password? </a> {else} <span>&nbsp;</span> {/if}
        {elseif $step eq "reset"} <a href="login.php"> &laquo; Back to Login </a> {elseif $step eq "twofa"} <a href="login.php?{if $redirectUri}redirect={$redirectUri|urlencode}&amp;{/if}backupcode=1"> Can't Access Your 2nd Factor Device?<br />
        Login using Backup Code </a> {/if} </div>
      <div class="powered-by"><a href="https://www.accessystem.com/" target="_blank">Powered by ACCESSYSTEM® | IT Solution & Services Inc</a>.</div>
    </div>
    <div class="language-chooser">
      <div class="btn-group pull-right">
        <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false"> <span id="languageName">Choose Language</span> <span class="caret"></span> </button>
        <ul class="dropdown-menu" role="menu">
          {foreach $languages as $language}
          <li><a href="#">{$language|ucfirst}</a></li>
          {/foreach}
        </ul>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript" src="templates/login.js"></script>
</body>
</html>
