<?php
include_once DOCUMENT_ROOT_CLASS.'lib/Session.php';

class CommonFunctions
{   
    // Db Property
    //private $db;
    // Db __construct Method
    public function __construct()
    {
        $this->db = new Database();
    }
    //Get Data common function for multiple use
    public function getData($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }
    public function getRowData($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetch();
    }
    public function updateData($table,$con,$update_data,$redirect){
        try {
            $sql = "UPDATE ".$table." SET ".$update_data." ".$con;
            $this->db->pdo->exec($sql);
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }
            Session::set('msg', '<div class="alert alert-success alert-dismissible mt-3" id="flash-msg">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <strong>Success !</strong> Wow, Your Information updated Successfully !</div>');
        }catch(PDOException $e) {
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }
            Session::set('msg', '<div class="alert alert-danger alert-dismissible mt-3" id="flash-msg">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Error !</strong> Data not updated !</div>');
        }
    }
    public function addData($table,$adding_data,$redirect){
        try {
            $sql = "INSERT INTO ".$table." ".$adding_data;
            $this->db->pdo->exec($sql);
            Session::set('msg', '<div class="alert alert-success alert-dismissible mt-3" id="flash-msg">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <strong>Success !</strong> Wow, Your Information added Successfully !</div>');
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }else{
                return $this->db->pdo->lastInsertId();
            }
        }catch(PDOException $e) {
            Session::set('msg', '<div class="alert alert-danger alert-dismissible mt-3" id="flash-msg">
<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
<strong>Error !</strong> Data not inserted !</div>');
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }
        }
    }
    function deleteRowData($table,$con,$update_data,$redirect){
        try {
            $sql = "UPDATE ".$table." SET ".$update_data." ".$con;
            $this->db->pdo->exec($sql);
            echo "<script>location.href='".$redirect."';</script>";
            Session::set('msg', '<div class="alert alert-success alert-dismissible mt-3" id="flash-msg">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <strong>Success !</strong> Wow, Your Information deleted Successfully !</div>');
        }catch(PDOException $e) {
            echo "<script>location.href='".$redirect."';</script>";
            Session::set('msg', '<div class="alert alert-danger alert-dismissible mt-3" id="flash-msg">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
    <strong>Error !</strong> Something went wrong from server side. please try again !</div>');
        }
    }
    //get columun value 
    function getName($id, $table, $field = 'name', $key = 'id', $msg = '') {
        $sql = "SELECT $field FROM $table WHERE $key = $id ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        $resultData = $stmt->fetch();
        return $resultData[$field];
    }
    public function getRowDataCount($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return !empty($stmt->rowCount())?$stmt->rowCount():0;      
    }
    public function getRecordCount($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return !empty($stmt->rowCount())?$stmt->rowCount():0;      
    }
    public function getIDs($table,$field,$con = null){
        $sql = "SELECT GROUP_CONCAT($field) as ids FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetch();
    }
    public function addImportData($table,$adding_data,$redirect){   
        $sql = "INSERT INTO ".$table." ".$adding_data;
        return $this->db->pdo->exec($sql);
    }
    public function addLogData($table,$adding_data,$redirect=null){
        try {
            $sql = "INSERT INTO ".$table." ".$adding_data;
            $this->db->pdo->exec($sql);
        }catch(PDOException $e) {

        }
    }
    function random_num($len)
    {
        $ch = "0";
        $l = strlen ($ch) - 1;
        $str = "";
        for ($i=0; $i < $len; $i++)
        {
            $x = rand (0, $l);
            $str .= $ch[$x];
        }
        return $str;
    }
    function get_print_receipt_html($ReceiptNo,$url_bar){
        $html = '';
        $date = $this->getName(@$ReceiptNo,'sys_receipts','CreatedDate','ReceiptNo');
        $html .= '<div class="col-md-12 col-lg-12 DivIdToPrint">
            <div class="card report-card">
                <div class="card-body" >
                    <div class="row d-flex justify-content-center">
                        <style type="text/css">
                            .receipt-logo{ width: 9em; height: 9em; }
                        </style>
                        <table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
                            <tr>
                                <td style="width:30%">
                                    <img src="../uploads/logo-receipt.jpg" class="receipt-logo">
                                </td>
                                <td>
                                    <h2 style="text-align: center;" >QATAR GENETIC LAB</h2>
                                    <h5 style="text-align: center;">Racing and Euestrain Club,<br>Al Furousiya Street,<br>Al Rayyan, Doha, Qatar</h5>
                                    <h5 style="text-align: center;">CASH/CHEQUE RECEIPT VOUCHER</h5>
                                </td>
                                <td style="text-align: right;">
                                    <img src="../uploads/logo-receipt-1.jpg" class="receipt-logo">
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 25%;">
                                    <h4>Receipt No. '.$ReceiptNo.' </h4>
                                    <img alt="barcode" src="'.$url_bar.'" style="padding-bottom: 0.5em;"/>
                                </td>
                                <td>
                                    <table border="1" cellpadding="0" cellspacing="0" style="width:100%;">
                                        <tr>
                                            <td style="width: 20%;padding: 0.3em;"><h4>Amount</h4></td>
                                            <td style="padding: 0.3em;">
                                                <h4>'.$this->getName($ReceiptNo,'sys_receipts','Amount','ReceiptNo').' /- QAR</h4>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td style="text-align: right;">
                                    <h4>Date: '.date("jS M Y", strtotime($date)).'</h4>
                                </td>
                            </tr>
                        </table>
                        <table border="2" cellpadding="5" cellspacing="5" style="width:100%;">
                            <tr>
                                <td>
                                    <table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Customer Name </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 3px dotted;">'.$this->getName(@$ReceiptNo,'sys_receipts','CustomerName','ReceiptNo').'</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Membership Number </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 3px dotted;">'.$this->getName(@$ReceiptNo,'sys_receipts','MembershipNumber','ReceiptNo').'</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Amount </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 3px dotted;">'. $this->getName(@$ReceiptNo,'sys_receipts','Amount','ReceiptNo').'</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Payment Type  </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 3px dotted;">'.$this->getName(@$ReceiptNo,'sys_receipts','PaymentType','ReceiptNo').'</h4>  
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Service Type </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 3px dotted;">'.$this->getName(@$ReceiptNo,'sys_receipts','ServiceType','ReceiptNo').'</h4>  
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Appointment Date </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 3px dotted;">'.$this->getName(@$ReceiptNo,'sys_receipts','AppointmentDate','ReceiptNo').'</h4>  
                                            </td>
                                        </tr>
                                    </table>
                                    <table border="0" cellspacing="0" cellpadding="0" style="width: 100%;">
                                        <tr>
                                            <td style="width: 20%;text-align: center;"> 
                                                <br><br><br><h4>Receiver Sign</h4><br><br>
                                                <h4 style="border-bottom: 3px dotted;"></h4>
                                            </td>
                                            <td style="width: 60%;">

                                            </td>
                                            <td style="width: 20%;text-align: center;"> 
                                                <br><br><br><h4>Accountant Sign</h4><br><br>
                                                <h4 style="border-bottom: 3px dotted;"></h4>
                                            </td>
                                        </tr>

                                    </table>                
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>';
        return $html;
    }
}
?>