<?php
include_once DOCUMENT_ROOT_CLASS.'lib/Session.php';

class CommonFunctions
{   
    // Db Property
    //private $db;
    // Db __construct Method
    public function __construct()
    {
        $this->db = new Database();
    }
    //Get Data common function for multiple use
    public function getData($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }
    public function getRowData($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetch();
    }
    public function updateData($table,$con,$update_data,$redirect){
        try {
            $sql = "UPDATE ".$table." SET ".$update_data." ".$con;
            $this->db->pdo->exec($sql);
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }
            Session::set('msg', '<div class="alert alert-success alert-dismissible mt-3" id="flash-msg">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <strong>Success !</strong> Wow, Your Information updated Successfully !</div>');
        }catch(PDOException $e) {
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }
            Session::set('msg', '<div class="alert alert-danger alert-dismissible mt-3" id="flash-msg">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Error !</strong> Data not updated !</div>');
        }
    }
    public function addData($table,$adding_data,$redirect){
        try {
            $sql = "INSERT INTO ".$table." ".$adding_data;
            $this->db->pdo->exec($sql);
            Session::set('msg', '<div class="alert alert-success alert-dismissible mt-3" id="flash-msg">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <strong>Success !</strong> Wow, Your Information added Successfully !</div>');
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }else{
                return $this->db->pdo->lastInsertId();
            }
        }catch(PDOException $e) {
            Session::set('msg', '<div class="alert alert-danger alert-dismissible mt-3" id="flash-msg">
<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
<strong>Error !</strong> Data not inserted !</div>');
            if($redirect != ''){
                echo "<script>location.href='".$redirect."';</script>";
            }
        }
    }
    function deleteRowData($table,$con,$update_data,$redirect){
        try {
            $sql = "UPDATE ".$table." SET ".$update_data." ".$con;
            $this->db->pdo->exec($sql);
            echo "<script>location.href='".$redirect."';</script>";
            Session::set('msg', '<div class="alert alert-success alert-dismissible mt-3" id="flash-msg">
              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
              <strong>Success !</strong> Wow, Your Information deleted Successfully !</div>');
        }catch(PDOException $e) {
            echo "<script>location.href='".$redirect."';</script>";
            Session::set('msg', '<div class="alert alert-danger alert-dismissible mt-3" id="flash-msg">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
    <strong>Error !</strong> Something went wrong from server side. please try again !</div>');
        }
    }
    //get columun value 
    function getName($id, $table, $field = 'name', $key = 'id', $msg = '') {
        $sql = "SELECT $field FROM $table WHERE $key = $id ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        $resultData = $stmt->fetch();
        return $resultData[$field];
    }
    public function getRowDataCount($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return !empty($stmt->rowCount())?$stmt->rowCount():0;      
    }
    public function getRecordCount($table,$con = null){
        $sql = "SELECT * FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return !empty($stmt->rowCount())?$stmt->rowCount():0;      
    }
    public function getIDs($table,$field,$con = null){
        $sql = "SELECT GROUP_CONCAT($field) as ids FROM $table ";
        if(!empty($con)){
            $sql .= $con;
        }
        //$sql .= " ORDER BY id DESC ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        return $stmt->fetch();
    }
    public function addImportData($table,$adding_data,$redirect){   
        $sql = "INSERT INTO ".$table." ".$adding_data;
        return $this->db->pdo->exec($sql);
    }
    public function addLogData($table,$adding_data,$redirect=null){
        try {
            $sql = "INSERT INTO ".$table." ".$adding_data;
            $this->db->pdo->exec($sql);
        }catch(PDOException $e) {

        }
    }
    function random_num($len)
    {
        $ch = "0123456789";
        $l = strlen ($ch) - 1;
        $str = "";
        for ($i=0; $i < $len; $i++)
        {
            $x = rand (0, $l);
            $str .= $ch[$x];
        }
        return $str;
    }
    function check_module_permission($module_name,$role_id){
        $sql = "SELECT p.display FROM `sys_erp_access_permission` as p JOIN sys_erp_module as m ON m.id = p.module_id WHERE p.role_id = '".$role_id."' and m.name = '".$module_name."' ";
        $stmt = $this->db->pdo->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch();
        return !empty($result["display"])?$result["display"]:0;
    }
    function get_print_payment_voucher_html($PaymentVoucherNo,$url_bar){
        $html = '';
        $date = $this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','CreatedDate','PaymentVoucherNo');
        $orgData = $this->getRowData("sys_erp_organaization","");
        $html .= '<style>
        td{ font-size:12px; }
        h4,h5 { padding: 0px; margin: 3px; }
        </style>
        <div class="col-md-12 col-lg-12 DivIdToPrint">
            <div class="card report-card">
                <div class="card-body" >
                    <div class="row d-flex justify-content-center">
                        <style type="text/css">
                            .receipt-logo{ height: 4.5em; }
                        </style>
                        <table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
                            <tr>
                                <td>
                                    <img src="'.DOCUMENT_ROOT_CLASS.'uploads/admin-setting/company/'.@$orgData['erp_sys_org_logo'].'" class="receipt-logo">
                                </td>
                                <td>
                                    <h2 style="text-align: center;" >'.@$orgData['erp_sys_org_name'].'</h2>
                                    <h5 style="text-align: center;">'.@$orgData['erp_sys_org_address'].' <br>'.$this->getName(@$orgData['erp_sys_org_country'],'sys_erp_adm_countries','label','rowid').', '.$orgData['erp_sys_org_city'].'<br>P.O.Box - '.$orgData['erp_sys_org_province'].'</h5>
                                    <h5 style="text-align: center;">CASH/CHEQUE RECEIPT VOUCHER</h5>
                                </td>
                                <td style="text-align: right;">
                                   <img alt="barcode" src="'.$url_bar.'" style="padding-bottom: 0.3em;" width="120x" style="border: 1px solid;padding-top: 1em;"/>
                                   <h4>Date: '.date("jS M Y", strtotime($date)).'</h4>
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 22%;">
                                    <h5>Payment Voucher No. '.$PaymentVoucherNo.' </h5>
                                </td>
                                <td>
                                    <table border="1" cellpadding="0" cellspacing="0" style="width:100%;">
                                        <tr>
                                            <td style="width:40%;padding-left: 0.3em;"><h4>Amount Paid</h4></td>
                                            <td style="padding-left: 0.3em;">
                                                <h4>'.$this->getName($PaymentVoucherNo,'fin_accnt_pymt_vchr','AmountPaid','PaymentVoucherNo').' /- QAR</h4>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                </td>
                                <td style="text-align: right;">
                                    
                                </td>
                            </tr>
                        </table>
                        <table border="2" cellpadding="5" cellspacing="5" style="width:100%;">
                            <tr>
                                <td>
                                    <table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Customer Name </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','CustomerName','PaymentVoucherNo').'</h4> 
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>إسم العميل </h4> 
                                            </td>
                                        </tr> 
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Membership Number </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','MembershipNumber','PaymentVoucherNo').'</h4> 
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>رقم عضوية المشارك</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Amount Paid</h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'. $this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','AmountPaid','PaymentVoucherNo').'</h4> 
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>المبلغ</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Payment Type  </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','PaymentType','PaymentVoucherNo').'</h4>  
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>نوع الدفع  </h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Service Type </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','ServiceType','PaymentVoucherNo').'</h4>  
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>الفحص المطلوب </h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Appointment Date </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$PaymentVoucherNo,'fin_accnt_pymt_vchr','AppointmentDate','PaymentVoucherNo').'</h4>  
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>تاريخ الموعد </h4> 
                                            </td>
                                        </tr>
                                    </table>
                                    <table border="0" cellspacing="0" cellpadding="0" style="width: 100%;">
                                        <tr>
                                            <td style="width: 20%;text-align: center;"> 
                                                <br><br><br><h4>Receiver Sign</h4><br><br>
                                                <h4 style="border-bottom: 3px dotted;"></h4>
                                            </td>
                                            <td style="width: 60%;">

                                            </td>
                                            <td style="width: 20%;text-align: center;"> 
                                                <br><br><br><h4>Accountant Sign</h4><br><br>
                                                <h4 style="border-bottom: 3px dotted;"></h4>
                                            </td>
                                        </tr>

                                    </table>                
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>';
        return $html;
    }
    function get_print_receipt_voucher_html($RecieptVoucherNo,$url_bar){
        $html = '';
        $date = $this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','CreatedDate','RecieptVoucherNo');
        $orgData = $this->getRowData("sys_erp_organaization","");
        $html .= '<style>
        td{ font-size:12px; }
        h4,h5 { padding: 0px; margin: 3px; }
        </style>
        <div class="col-md-12 col-lg-12 DivIdToPrint">
            <div class="card report-card">
                <div class="card-body" >
                    <div class="row d-flex justify-content-center">
                        <style type="text/css">
                            .receipt-logo{ height: 4.5em; }
                        </style>
                        <table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
                            <tr>
                                <td>
                                    <img src="'.DOCUMENT_ROOT_CLASS.'uploads/admin-setting/company/'.@$orgData['erp_sys_org_logo'].'" class="receipt-logo">
                                </td>
                                <td>
                                    <h2 style="text-align: center;" >'.@$orgData['erp_sys_org_name'].'</h2>
                                    <h5 style="text-align: center;">'.@$orgData['erp_sys_org_address'].' <br>'.$this->getName(@$orgData['erp_sys_org_country'],'sys_erp_adm_countries','label','rowid').', '.$orgData['erp_sys_org_city'].'<br>P.O.Box - '.$orgData['erp_sys_org_province'].'</h5>
                                    <h5 style="text-align: center;">CASH/CHEQUE RECEIPT VOUCHER</h5>
                                </td>
                                <td style="text-align: right;">
                                   <img alt="barcode" src="'.$url_bar.'" style="padding-bottom: 0.3em;" width="120x" style="border: 1px solid;padding-top: 1em;"/>
                                   <h4>Date: '.date("jS M Y", strtotime($date)).'</h4>
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 22%;">
                                    <h5>Payment Voucher No. '.$RecieptVoucherNo.' </h5>
                                </td>
                                <td>
                                    <table border="1" cellpadding="0" cellspacing="0" style="width:100%;">
                                        <tr>
                                            <td style="width:40%;padding-left: 0.3em;"><h4>Amount Received</h4></td>
                                            <td style="padding-left: 0.3em;">
                                                <h4>'.$this->getName($RecieptVoucherNo,'fin_accnt_pymt_rpct','AmountReceived','RecieptVoucherNo').' /- QAR</h4>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                </td>
                                <td style="text-align: right;">
                                    
                                </td>
                            </tr>
                        </table>
                        <table border="2" cellpadding="5" cellspacing="5" style="width:100%;">
                            <tr>
                                <td>
                                    <table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Customer Name </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','CustomerName','RecieptVoucherNo').'</h4> 
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>إسم العميل </h4> 
                                            </td>
                                        </tr>
                                         
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Membership Number </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','MembershipNumber','RecieptVoucherNo').'</h4> 
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>رقم عضوية المشارك</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Amount Received</h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'. $this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','AmountReceived','RecieptVoucherNo').'</h4> 
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>المبلغ</h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Payment Type  </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','PaymentType','RecieptVoucherNo').'</h4>  
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>نوع الدفع  </h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Service Type </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','ServiceType','RecieptVoucherNo').'</h4>  
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>الفحص المطلوب </h4> 
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:20%;">
                                                <h4>Appointment Date </h4> 
                                            </td>
                                            <td colspan="2">
                                                <h4 style="width: 100%;border-bottom: 2px dotted; text-align: center;">'.$this->getName(@$RecieptVoucherNo,'fin_accnt_pymt_rpct','AppointmentDate','RecieptVoucherNo').'</h4>  
                                            </td>
                                            <td style="width:20%;text-align: right;font-size: 20px; font-weight:600;">
                                                <h4>تاريخ الموعد </h4> 
                                            </td>
                                        </tr>
                                    </table>
                                    <table border="0" cellspacing="0" cellpadding="0" style="width: 100%;">
                                        <tr>
                                            <td style="width: 20%;text-align: center;"> 
                                                <br><br><br><h4>Receiver Sign</h4><br><br>
                                                <h4 style="border-bottom: 3px dotted;"></h4>
                                            </td>
                                            <td style="width: 60%;">

                                            </td>
                                            <td style="width: 20%;text-align: center;"> 
                                                <br><br><br><h4>Accountant Sign</h4><br><br>
                                                <h4 style="border-bottom: 3px dotted;"></h4>
                                            </td>
                                        </tr>
                                    </table>                
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>';
        return $html;
    }
} ?>