<?php 
define('DOCUMENT_ROOT_CLASS','../../');
define('DOCUMENT_ROOT_INC_FOLDER','inc/');
$filepath = realpath(dirname(__FILE__));
require "../../inc/header.php";
$msg = Session::get('msg');
Session::set("msg", NULL);
$productData = $commonFunctions->getRowData('invty_pdt_details'," WHERE id = '".@$_GET['product_id']."' ");
?>
	<!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid">
            <!-- Page-Title -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box">
                        <div class="row">
                            <div class="col form-row">
                            	<div class="col-sm-9">
	                                <h4 class="page-title"><?php echo @$productData['label'];?></h4>
	                                <ol class="breadcrumb">
	                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Products & Services</a></li>
	                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Products</a></li>
	                                    <li class="breadcrumb-item"><a href="javascript:void(0);">Products Details</a></li>
	                                </ol>
	                            </div>
                                <div class="col-sm-3">
	                                <a href="product.php?state=edit&product_id=<?php echo $productData['id'];?>">
	                                	<button type="button" class="btn btn-sm btn-outline-primary">Edit</button>
	                                </a>
	                                <a href="product.php?state=copy&product_id=<?php echo $productData['id'];?>">
	                                	<button type="button"class="btn btn-sm btn-outline-dark">Duplicate</button>
	                                </a>
	                                <a href="product.php?state=list"><button type="button" class="btn btn-sm btn-outline-secondary clear_form">Back to Products List</button></a>
	                                <!-- <button type="button" class="btn btn-sm btn-outline-danger">Delete</button> -->
	                            </div>
                            </div><!--end col-->
                        </div><!--end row-->                                                              
                    </div><!--end page-title-box-->
                </div><!--end col-->
            </div><!--end row-->
            <!-- end page title end breadcrumb -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="dastone-profile">
                                <div class="row">
                                    <div class="col-lg-3 align-self-center mb-lg-0">
                                        <div class="dastone-profile-main">
                                            <div class="dastone-profile_user-detail">
                                                <img src="../../uploads/product-services/product-images/<?php echo @$productData['product_images'];?>" width="80px">                                              
                                            </div>
                                        </div>                                                
                                    </div><!--end col-->
                                    <div class="col-lg-4 align-self-center mb-lg-0">
                                        <div class="dastone-profile-main">
                                            <div class="dastone-profile_user-detail">
                                                <?php 
                                                $barcode_type = $commonFunctions->getname($productData['barcode_type'],'tbl_barcode_type','label','id');
                                                //echo "<img alt='testing' src='../../lib/barcode.php?codetype=".$barcode_type."&size=40&text=".@$productData['barcode_value']."&print=true'/>";
                                                ?>
                                                <div id="barcodeTarget" class="barcodeTarget"></div>
												<canvas id="canvasTarget" width="150" height="150"></canvas>
                                            </div>
                                        </div>                                                
                                    </div><!--end col-->
                                    <div class="col-lg-5 align-self-center mb-lg-0">
                                        <div class="dastone-profile-main">
                                            <div class="dastone-profile_user-detail">
                                            	<b><?php echo @$productData['label'];?></b><br>
                                            	<?php if(@$productData['virtual_stock'] != 0): ?>
                                                	<span style="color: green;">IN STOCK</span>
                                                <?php else: ?>
                                                	<span style="color: red;">OUT OF STOCK</span>
                                                <?php endif; ?>
                                            </div>
                                        </div>                                                
                                    </div><!--end col-->

                                </div><!--end row-->
                            </div><!--end f_profile-->                                                                                
                        </div><!--end card-body-->          
                    </div> <!--end card-->    
                </div><!--end col-->
            </div><!--end row-->
            <div class="pb-4">
                <ul class="nav-border nav nav-pills mb-0" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="product_details_tab" data-toggle="pill" href="#product_details">Product Details</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="purchase_details_tab" data-toggle="pill" href="#purchase_details">Purchase Details</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="related_invoice_tab" data-toggle="pill" href="#related_invoice">Related Invoice</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="statistics_tab" data-toggle="pill" href="#statistics">Statistics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="note_tab" data-toggle="pill" href="#note">Note</a>
                    </li>
                </ul>        
            </div><!--end card-body-->
            <style type="text/css">
            	label.form-control1 {display: block;}
            	label.label-title {font-weight: 600;}
            </style>
            <div class="row">
                <div class="col-12">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="product_details" role="tabpanel" aria-labelledby="product_details_tab">
                        	<div class="card">
                        		<div class="card-body">
		                        	<div class="form-row">
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="label" class="label-title">Label / Product Name</label>
			                                <label class="form-control1"><?php echo @$productData['label'];?></label>
			                            </div>

			                            <div class="col-md-4 position-relative form-group">
			                                <label for="sales_status" class="label-title">Sales Status</label>
			                                <label class="form-control1">
			                                    <?php echo (@$productData['sales_status'] == 1)?"For Sale":"";?><?php echo (!empty($productData) and @$productData['sales_status'] == 0)?"Not For Sale":"";?>
			                                </label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="purchase_status" class="label-title">Purchase Status</label>
			                                <label class="form-control1">
			                                    <?php echo (@$productData['purchase_status'] == 1)?"For Purchase":"";?> >
			                                    <?php echo (!empty($productData) and @$productData['purchase_status'] == 0)?"Not For Purchase":"";?> >
			                                </label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="lot_serial_status" class="label-title">Use Lot / Serial Number </label>
			                                <label class="form-control1">
			                                    <?php echo (@$productData['lot_serial_status'] == 0)?"No ( Lot / Serial not Used )":"";?><?php echo (@$productData['lot_serial_status'] == 1)?"Yes ( Lot / Serial Required )":"";?>
			                                </label>
			                            </div>

			                            <div class="col-md-4 position-relative form-group">
			                                <label for="barcode_type" class="label-title">Barcode Type</label>
			                                <label class="form-control1" name="barcode_type" id="barcode_type">
			                                    <?php
			                                    $barcodeArr = $commonFunctions->getData('tbl_barcode_type',' WHERE active = 1 ');
			                                    foreach ($barcodeArr as $row) { ?>
			                                        <?php echo (@$productData['barcode_type'] == $row['id'])?$row['label']:"";?>
			                                    <?php } ?>
			                                </label>
			                            </div>
			                            
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="reference_number" class="label-title">Reference Number</label>
			                                <label class="form-control1"><?php echo @$productData['reference_number'];?></label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="barcode_value" class="label-title">Barcode Value</label>
			                                <label class="form-control1"><?php echo @$productData['barcode_value'];?></label>
			                            </div>
			                            <!-- <div class="col-md-4 position-relative form-group">
			                                <label for="description" class="label-title">Description</label>
			                                <label class="form-control1"><?php echo @$productData['description'];?></label>
			                            </div> -->
			                            
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="default_warehouse_id" class="label-title">Default Warehouse</label>
			                                <?php $warehouseData = $commonFunctions->getData('invty_wrhus',' WHERE status = 0 '); ?>
			                                <label class="form-control1">
			                                    <?php foreach ($warehouseData as $rw) { ?>
			                                        <?php echo (@$productData['default_warehouse_id'] == $rw['id'])?$rw['short_name_location']:"";?>
			                                    <?php } ?>
			                                </label>
			                            </div>

			                            <div class="col-md-4 position-relative form-group">
			                                <label for="stock_limit_alert" class="label-title">Stock Limit for Alert</label>
			                                <label class="form-control1"><?php echo (empty(@$productData['stock_limit_alert']))?0:@$productData['stock_limit_alert'];?>
			                            	</label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="desired_optimal_stock" class="label-title">Desired Optimal Stock</label>
			                                <label class="form-control1">
			                                	<?php echo (empty(@$productData['desired_optimal_stock']))?0:@$productData['desired_optimal_stock'];?>
			                                </label>
			                            </div>

			                            <div class="col-md-4 position-relative form-group">
			                                <label for="nature" class="label-title">Nature</label>
			                                <label class="form-control1">
			                                   <?php echo (@$productData['nature'] == 0)?"Raw Material":"";?>
			                                    <?php echo (@$productData['nature'] == 1)?"Manufactured Product":"";?>
			                                </label>
			                            </div>

			                            <div class="col-md-4 position-relative form-group">
			                                <label for="note" class="label-title">Note (not visible on Invoices, Proposals...)</label>
			                                <label class="form-control1"><?php echo @$productData['note'];?></label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="buying_price" class="label-title">Buying Price</label>
			                                <label class="form-control1"><?php echo @$productData['buying_price'];?></label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="cost_price" class="label-title">Cost Price</label>
			                                <label class="form-control1"><?php echo @$productData['cost_price'];?></label>
			                            </div>		                            

			                            <div class="position-relative form-group col-md-4">
			                                <label for="tag_id" class="label-title"> Tags / Categories </label>
			                                <?php $TagData = $commonFunctions->getData('invty_pdt_tag',''); ?>
			                                <label class="form-control1" >
			                                    
			                                    <?php foreach ($TagData as $rw) { ?>
			                                        <?php if(@$productData['tag_id'] == $rw['id']){
				                                        if($rw['parent_id'] > 0){
				                                            echo $commonFunctions->getName($rw['parent_id'],'crm_cust_tag_','label','id')." >> ";           
				                                        }
				                                        echo $rw['label']; 
				                                    } ?>
			                                    <?php } ?>
			                                </label>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="price" class="label-title">Selling Price </label>
			                                <div style="display: flex;">   
			                                    <label style="width:70%" class="form-control1">
			                                    	<?php echo (empty(@$productData['price']))?0:@$productData['price'];?>
			                                    </label>
			                                    <label class="form-control1" style="width:30%">
			                                        
			                                        <?php echo (@$productData['nature'] == "HT")?"Net of TAX":"";?>
			                                        <?php echo (@$productData['nature'] == "TTC")?"Inc. TAX":"";?>
			                                    </label>
			                                </div>
			                            </div>
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="min_price" class="label-title">Min. Selling Price</label>
			                                <label class="form-control1">
			                                	<?php echo (empty(@$productData['min_price ']))?0:@$productData['min_price '];?>
			                                </label>
			                            </div>

			                            <div class="position-relative form-group col-md-4">
			                                <label for="tax_management_id" class="label-title"> VAT Rate   </label>
			                                <label class="form-control1"></label>
			                            </div>
			                            
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="duration" class="label-title">Duration </label>
			                                <div style="display: flex;">   
			                                    <label type="text" class="form-control1" style="width:70%">
			                                    	<?php echo @$productData['duration'];?>
			                                    </label>
			                                    <label class="form-control1" style="width:30%">
			                                        <?php echo (@$productData['nature'] == "i")?"I":"";?><?php echo (@$productData['nature'] == "h")?"H":"";?><?php echo (@$productData['nature'] == "d")?"D":"";?><?php echo (@$productData['nature'] == "w")?"W":"";?><?php echo (@$productData['nature'] == "m")?"M":"";?><?php echo (@$productData['nature'] == "y")?"Y":"";?>
			                                    </label>
			                                </div>
			                            </div>
			                            
			                            <div class="col-md-4 position-relative form-group">
			                                <label for="selling_type" class="label-title">Selling Type</label>
			                                <label class="form-control1">
			                                	<?php echo (@$productData['selling_type'] == 0)?"Fixed Amount":"";?><?php echo (@$productData['selling_type'] == 1)?"Recurring Amount":"";?> 
			                                </label>

			                            </div>
			                        </div>
			                    </div>
                        	</div>
                        </div>
                        <div class="tab-pane" id="purchase_details" role="tabpanel" aria-labelledby="purchase_details_tab">
                            <div class="card">
                        		<div class="card-body">
                                	Purchase Details
                            	</div><!--end row-->    
                            </div>
                        </div>
                        <div class="tab-pane" id="related_invoice" role="tabpanel" aria-labelledby="related_invoice_tab">
                            <div class="card">
                        		<div class="card-body">
                                	Related Invoice
                            	</div><!--end row-->    
                            </div> <!--end row-->
        				</div>
                        <div class="tab-pane" id="statistics" role="tabpanel" aria-labelledby="statistics_tab">
                            <div class="card">
                        		<div class="card-body">
                                	Statistics
                            	</div><!--end row-->    
                            </div>
                        </div>
                        <div class="tab-pane" id="note" role="tabpanel" aria-labelledby="note_tab">
                            <div class="card">
                        		<div class="card-body">
	                            	<div class="form-row">
	                            		<div class="col-md-12 position-relative form-group">
	                            			<?php echo @$productData['description'];?>
	                            		</div>
	                            	</div>
	                            </div>
                            </div><!--end row-->
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- container -->
    </div>
    <!-- end page content -->
<?php require "../../inc/footer.php"; ?>
<script type="text/javascript" src="https://www.jqueryscript.net/demo/Simple-jQuery-Based-Barcode-Generator-Barcode/jquery-barcode.js"></script>
<script type="text/javascript">
    
  	function generateBarcode(){
	    var value = "<?php echo strtolower(@$productData['barcode_value']); ?>";
	    var btype = "<?php echo strtolower(@$barcode_type); ?>";
	    var renderer = "css";
    	var quietZone = false;
	    
	    var settings = {
	      	output:renderer,
	      	bgColor: "#FFFFFF",
	      	color: "#000000",
	      	barWidth: "2",
	     	barHeight: "50",
	      	moduleSize: "5",
	      	posX: "10",
	      	posY: "20",
	      	addQuietZone: "1"
	    };
    	if (renderer == 'canvas'){
      		clearCanvas();
	      	$("#barcodeTarget").hide();
	      	$("#canvasTarget").show().barcode(value, btype, settings);
    	} else {
      		$("#canvasTarget").hide();
      		$("#barcodeTarget").html("").show().barcode(value, btype, settings);
    	}
  	}
      
  	function showConfig1D(){
	    $('.config .barcode1D').show();
	    $('.config .barcode2D').hide();
  	}
  
  	function showConfig2D(){
	    $('.config .barcode1D').hide();
	    $('.config .barcode2D').show();
  	}
  
  	function clearCanvas(){
	    var canvas = $('#canvasTarget').get(0);
	    var ctx = canvas.getContext('2d');
	    ctx.lineWidth = 1;
	    ctx.lineCap = 'butt';
	    ctx.fillStyle = '#FFFFFF';
	    ctx.strokeStyle  = '#000000';
	    ctx.clearRect (0, 0, canvas.width, canvas.height);
	    ctx.strokeRect (0, 0, canvas.width, canvas.height);
  	}
  
  	$(function(){
    	generateBarcode();
  	});

</script>